USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [app].[NVCC_usp_GetVisits]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: NVCC_usp_GetVisits
--SERVER				: DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-14-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Retrieve a patient's prior encounters for provider
--                        review while compiling NVCC documentation.  This data
--                        used to be retrieved from appointment data, but visit
--                        data is more appropriate since this data comes from
--                        encounters that actually happened.  Appointments can be
--                        cancelled or no-show.
--=================================================================================
BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT
      convert(varchar, VisitDateTime, 101) + ' ' + convert(varchar, VisitDateTime, 8) AS VisitDateTime
     ,a.Sta3n
     ,b.InstitutionName
     ,c.StopCodeName
     ,d.LocationName
     ,e.AppointmentType
     ,f.AppointmentStatus

   FROM CDWWork.Outpat.Visit a
   JOIN CDWWork.Dim.Institution b on b.InstitutionSID = a.InstitutionSID
   JOIN CDWWork.Dim.StopCode c on c.StopCodeSID = a.PrimaryStopCodeSID
   JOIN CDWWork.Dim.Location d ON d.LocationSID = a.LocationSID
   JOIN CDWWork.Dim.AppointmentType e on e.AppointmentTypeSID = a.AppointmentTypeSID
   JOIN CDWWork.Dim.AppointmentStatus f on f.AppointmentStatusSID = a.AppointmentStatusSID

   WHERE a.VisitDateTime >= convert(DATE, dateadd(month, -6, getdate()))
     AND a.PatientSID in (select PTSid from [App].[udf_AllPatientsSIDs](@pid))

   ORDER BY a.VisitDateTime DESC;
END;

GO
